<div class="control-group {$style.classes}">
    <div class="row">
        {if $label}
            <div class="col-md-{12 - $style.width}">
                <label class="control-label">
                    {$MGLANG->T('forms', 'labels', $label)}
                </label>
            </div>
        {/if}

        <div class="col-md-{$style.width}">
            <input 
                type="checkbox"  
                class="autogenerated-bootstrap-switcher" 
                name="{$name}" 
                data-on-text="{$MGLANG->T('Enabled')}" 
                data-off-text="{$MGLANG->T('Disabled')}" 
                data-on-color="{if $style.oncolor}{$style.oncolor}{else}success{/if}"
                data-off-color="{if $style.offcolor}{$style.offcolor}{else}default{/if}"  
                data-size="{if $style.size}{$style.size}{else}mini{/if}" 
                data-label-width="15" 
                {if $value}checked{/if}
                {foreach from=$data key=dataKey item=dataValue}
                    data-{$dataKey}="{$dataValue}"
                {/foreach}
                style="{foreach from=$style.custom key=stl item=val}{$stl}:{$val};{/foreach}" 
            />
        </div>
    </div>

    {if $description}
        <div class="row">
            <div class="col-md-offset-{12 - $style.width} col-md-{$style.width}">
                <span class="help-block">
                    {$MGLANG->T('forms', 'help', $description)}
                </span>
            </div>
        </div>
    {/if}
</div>

<script type="text/javascript">
    $(document).ready(function()
    {
        $(".autogenerated-bootstrap-switcher").bootstrapSwitch();
    });
</script>