{literal}
    <style type="text/css">
        .hidden {
            display: none!important;
        }
    </style>
{/literal}

{include file="$template/invoice-payment.tpl"}

<script language="javascript">
    var rcForm = jQuery('form#frmPayment');
    rcForm.css("display","flex");
    rcForm.append('<input type="hidden" name="action" value="submit" />');

    function validateRcStripe(event) {
        var submitButton = jQuery('#btnSubmit');

        var newOrExisting = jQuery('input[name="ccinfo"]:checked').val();
        jQuery("div.alert-danger,.alert-lagom").hide();

        if (newOrExisting !== "new") {
            return true;
        }

        if (
            typeof recaptchaValidationComplete !== 'undefined'
            && typeof recaptchaType !== 'undefined'
            && recaptchaType === 'invisible'
            && recaptchaValidationComplete === false
        ) {
            event.preventDefault();
            return;
        }
        var paymentMethod = jQuery('input[name="paymentmethod"]:checked'),
            frm = elementsDiv.closest('form'),
            displayError = jQuery('.gateway-errors,.assisted-cc-input-feedback').first();

        if (paymentMethod.length && paymentMethod.val() !== 'stripe' && paymentMethod.val() !== 'Stripe') {
            return true;
        }
        event.preventDefault();
        frm.find('button[type="submit"],input[type="submit"]')
            .prop('disabled', true)
            .addClass('disabled')
            .find('span').toggle();

        stripe.createPaymentMethod(
            'card',
            card
        ).then(function(result) {
            if (result.error) {
                var error = result.error.message;
                if (error) {
                    displayError.html(error);
                    if (displayError.not(':visible')) {
                        displayError.slideDown();
                    }
                    scrollToGatewayInputError();
                }
                submitButton.prop('disabled', false).removeClass('disabled')
                    .find('span').first().show();
                event.preventDefault();
                return false;
            } else {
                ccForm = jQuery('form#frmPayment');
                ccForm.off("submit");
                ccForm.submit();
            }
        });
    }

    function unbindWrongEventListeners()
    {
        ccForm = jQuery('form#frmPayment');
        ccForm.off("submit");

        const form = document.getElementById("frmPayment");
        form.removeEventListener("submit", processExisting, false)
        jQuery(document).removeAttr('onsubmit');
        jQuery(document).unbind('submit');
        ccForm.on('submit', validateRcStripe);
    }

    jQuery(document).ready(function() {

        //setTimeout(unbindWrongEventListeners, 100);
        ccForm = jQuery('form#frmPayment');

        jQuery(document).removeAttr('onsubmit');
        jQuery(document).unbind('submit');
        ccForm.off("submit");
        ccForm.on('submit', validateRcStripe);

        jQuery(document).on('ifChecked', 'input[name="ccinfo"]', function() {
            setTimeout(unbindWrongEventListeners, 100);
        });

        var newCardPan = jQuery('a[href="#newCardInfoTab"');
        if (newCardPan.hasClass( "active" )) {
            jQuery('#newCardInfoTab').addClass("active");
        }
    });
</script>